% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_stochastic_growth.R
\name{predict_stochastic_growth}
\alias{predict_stochastic_growth}
\title{Isothermal growth with variability}
\usage{
predict_stochastic_growth(
  model_name,
  times,
  n_sims,
  pars,
  corr_matrix = diag(nrow(pars)),
  check = TRUE
)
}
\arguments{
\item{model_name}{Character describing the primary growth model.}

\item{times}{Numeric vector of storage times for the simulations.}

\item{n_sims}{Number of simulations.}

\item{pars}{A tibble describing the parameter uncertainty (see details).}

\item{corr_matrix}{Correlation matrix of the model parameters. Defined in the
same order as in \code{pars}. An identity matrix by default
(uncorrelated parameters).}

\item{check}{Whether to do some tests. \code{FALSE} by default.}
}
\value{
An instance of \code{\link{StochasticGrowth}}.
}
\description{
Stochastic simulation of microbial growth based on probability
distributions of the parameters of the primary model. It is included by
Monte Carlo simulation considering the parameters follow a multivariate normal
distribution.
}
\details{
They are defined in the \code{pars} argument using a tibble with 4 columns:
\itemize{
    \item{par: identifier of the model parameter (according to \code{\link{primary_model_data}})},
    \item{mean: mean value of the model parameter.},
    \item{sd: standard deviation of the model parameter.},
    \item{scale: scale at which the model parameter is defined. Valid values are
    'original' (no transformation), 'sqrt' square root or 'log' log-scale. The
    parameter sample is generated considering the parameter follows a marginal
    normal distribution at this scale, and is later converted to the original scale
    for calculations.}
}
}
\examples{
\donttest{
## Definition of the simulation settings

my_model <- "Baranyi"
my_times <- seq(0, 30, length = 100)
n_sims <- 3000

pars <- tribble(
    ~par, ~mean, ~sd, ~scale,
    "logN0", 0, .2, "original",
    "mu", 2, .3, "sqrt",
    "lambda", 4, .4, "sqrt",
    "logNmax", 6, .5, "original"
)

## Calling the function

stoc_growth <- predict_stochastic_growth(my_model, my_times, n_sims, pars)

## We can plot the results

plot(stoc_growth)

## Adding parameter correlation

my_cor <- matrix(c(1,   0,   0, 0,
    0,   1, 0.7, 0,
    0, 0.7,   1, 0,
    0,   0,   0, 1),
    nrow = 4)

stoc_growth2 <- predict_stochastic_growth(my_model, my_times, n_sims, pars, my_cor)

plot(stoc_growth2)
}

}
