% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{hasKey}
\alias{hasKey}
\alias{hasKey,gbFeature-method}
\alias{hasKey,gbFeatureTable-method}
\alias{hasKey,gbRecord-method}
\alias{hasKey,gbRecordList-method}
\title{Has a feature a specific key?}
\usage{
hasKey(x, key, ...)

\S4method{hasKey}{gbFeature}(x, key)

\S4method{hasKey}{gbFeatureTable}(x, key)

\S4method{hasKey}{gbRecord}(x, key)

\S4method{hasKey}{gbRecordList}(x, key)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{key}{A feature key.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A logical vector or a list of logical vectors.
}
\description{
Has a feature a specific key?
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
hasKey(x, 'CDS')
}
\seealso{
\code{\link{key}}
}
