## ---- include = FALSE---------------------------------------------------------
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-dic-estimate-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Curve fitting data options' box and 'Results' tabbed box in the dose estimation module"----
knitr::include_graphics("figures/screenshot-dicentrics-estimate-01.png")

## ----load-fitting-results, tidy=TRUE, tidy.opts=list(width.cutoff=60)---------
fit_results <- system.file("extdata", "dicentrics-fitting-results.rds", package = "biodosetools") %>%
  readRDS()

## ----fit-results--------------------------------------------------------------
fit_results$fit_coeffs

## ----sc-dic-estimate-02, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input options' and 'Data input' boxes in the dose estimation module"----
knitr::include_graphics("figures/screenshot-dicentrics-estimate-02.png")

## ----dic-case-data------------------------------------------------------------
case_data <- system.file("extdata", "cases-data-partial.csv", package = "biodosetools") %>%
  utils::read.csv(header = TRUE) %>%
  calculate_aberr_table(
    type = "case",
    assessment_u = 1
  ) %>%
  dplyr::rename(y = mean, y_err = std_err)

## -----------------------------------------------------------------------------
case_data

## ----sc-dic-estimate-03, echo=FALSE, out.width='60%', fig.align='center', fig.cap="'Dose estimation options' box in the dose estimation module"----
knitr::include_graphics("figures/screenshot-dicentrics-estimate-03.png")

## ----sc-dic-estimate-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Save results' boxes in the dose estimation module"----
knitr::include_graphics("figures/screenshot-dicentrics-estimate-04.png")

## ----dic-parse-fit-results----------------------------------------------------
fit_coeffs <- fit_results[["fit_coeffs"]]
fit_var_cov_mat <- fit_results[["fit_var_cov_mat"]]

## ----dic-dose-estimation-whole------------------------------------------------
results_whole_merkle <- estimate_whole_body_merkle(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int_yield = 0.83,
  conf_int_curve = 0.83,
  protracted_g_value = 1,
  aberr_module = "dicentrics"
)

## ----dic-dose-estimation-partial----------------------------------------------
results_partial <- estimate_partial_body_dolphin(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int = 0.95,
  protracted_g_value = 1,
  gamma = 1 / 2.7,
  aberr_module = "dicentrics"
)

## ----dic-estimated-dose-curve, fig.width=6, fig.height=3.5, fig.align='center'----
plot_estimated_dose_curve(
  est_doses = list(
    whole = results_whole_merkle,
    partial = results_partial
  ),
  fit_coeffs,
  fit_var_cov_mat,
  protracted_g_value = 1,
  conf_int_curve = 0.95,
  aberr_name = "Dicentrics"
)

