% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OED_isothermal.R
\name{detFIM}
\alias{detFIM}
\title{Objective function for D-optimal OED}
\usage{
detFIM(x, model, pars)
}
\arguments{
\item{x}{a numeric vector of length \code{n} defining the design matrix.
The first n/2 elements are the time points and the last n/2 are the
temperatures of these points.}

\item{model}{character string defining the inactivation model to use.}

\item{pars}{list defining the model parameters according to the rules defined in the bioinactivation package.}
}
\value{
Numeric value of the objective function for criterium D, which is a determinant of the FIM.
}
\description{
Objective function for D-optimal OED
}
\examples{
pars <- list(temp_crit = 55,
        n = 1.5,
        k_b = 0.1)
detFIM(x = c(10,15, 20, 25), "Peleg", pars)

}
