% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sensitivity.R
\name{sensitivity_inactivation}
\alias{sensitivity_inactivation}
\title{Local sensitivities of microbial inactivation}
\usage{
sensitivity_inactivation(inactivation_model, parms, temp_profile, parms_fix,
  n_times = 100, varscale = 1, parscale = 1, sensvar = "logN", ...)
}
\arguments{
\item{inactivation_model}{Character defining the inactivation model to use.}

\item{parms}{Numeric vector with the nominal values of the model parameters.}

\item{temp_profile}{Data frame describing the environmental conditions.}

\item{parms_fix}{Nominal value of the parameters not considered for the
sensitivity.}

\item{n_times}{Numeric value specifying the nombers of time points where 
the sensitivity functions will be calculated. 100 by default.}

\item{varscale}{The scaling factor for sensitivity variables. \code{NULL}
indicates that the variable value is used. 1 by default.}

\item{parscale}{The scaling factor for parameters. \code{NULL} indicates
that the parameter value is used. 1 by default.}

\item{sensvar}{The output variable for which the sensitivity will be 
estimated. \code{"logN"} by default.}

\item{...}{Additional arguments passed to sensFun}
}
\value{
A data.frame of class \code{sensFun}.
}
\description{
Calculates the local sensitivity function of a microbial inactivation
process. These are estimated using finite differences, through the function
\code{\link{sensFun}} from the \code{\link{FME}} package.
}
\examples{
parms_fix <- c(temp_ref = 57.5)
parms <- c(delta_ref = 3.9,
           z = 4.2,
           p = 1,
           N0 = 1e6
)

temp_profile <- data.frame(time = c(0, 60), temperature = c(30, 60)
)

sensitivity <- sensitivity_inactivation("Mafart", parms,
                               temp_profile, parms_fix)

plot(sensitivity)

}
\seealso{
\code{\link{sensFun}}
}
