% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gamma.R
\name{func_gamma}
\alias{func_gamma}
\title{Function: Utility Function}
\usage{
func_gamma(
  value,
  utility,
  reward,
  occurrence,
  var1 = NA,
  var2 = NA,
  gamma = 1,
  lambda
)
}
\arguments{
\item{value}{The expected value of the stimulus in the subject's mind at 
this point in time.}

\item{utility}{The subjective value that the subject assigns to the 
objective reward.}

\item{reward}{The objective reward received by the subject after selecting 
a stimulus.}

\item{occurrence}{The number of times the same stimulus has appeared.}

\item{var1}{[character] column name of extra variable 1. If your model uses 
more than just reward and expected value, and you need other information, 
such as whether the choice frame is Gain or Loss, then you can input the 
'Frame' column as var1 into the model.
e.g., `var1 = "Extra_Var1"`}

\item{var2}{[character] column name of extra variable 2. If one additional 
variable, var1, does not meet your needs, you can add another additional 
variable, var2, into your model.
e.g., `var2 = "Extra_Var2"`}

\item{gamma}{[vector] Parameters used in the Utility Function 
`util_func`, often referred to as the discount rate. For example,
`utility = reward^gamma`. If `gamma < 1`, it indicates that people
tend to discount the objective reward. This equation is very similar
to the Stevens' power function, reflecting humans' nonlinear perception
of physical quantities. 
e.g., `gamma = c(0.7)`.}

\item{lambda}{[vector] Extra parameters that may be used in functions. 
e.g., `lambda = c(0.4, 0.7, 20, 60)`}
}
\value{
Discount rate and utility
}
\description{
Function: Utility Function
}
\note{
When customizing these functions, please ensure that you do not modify 
the arguments. Instead, only modify the `if-else` statements or the internal 
logic to adapt the function to your needs.
}
