% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-dataset.R
\name{api-dataset}
\alias{api-dataset}
\alias{bq_dataset_create}
\alias{bq_dataset_meta}
\alias{bq_dataset_exists}
\alias{bq_dataset_update}
\alias{bq_dataset_delete}
\alias{bq_dataset_tables}
\title{BigQuery datasets}
\usage{
bq_dataset_create(x, location = "US", ...)

bq_dataset_meta(x, fields = NULL)

bq_dataset_exists(x)

bq_dataset_update(x, ...)

bq_dataset_delete(x, delete_contents = FALSE)

bq_dataset_tables(x, page_size = 50, max_pages = Inf, warn = TRUE,
  ...)
}
\arguments{
\item{x}{A \link{bq_dataset}}

\item{location}{Dataset location}

\item{...}{Additional arguments passed on to the underlying API call.
snake_case names are automatically converted to camelCase.}

\item{fields}{An optional field specification for
\href{https://cloud.google.com/bigquery/docs/api-performance#partial-response}{partial response}}

\item{delete_contents}{If \code{TRUE}, will recursively delete all tables in
the dataset. Set to \code{FALSE} by default for safety.}

\item{page_size}{Number of items per page.}

\item{max_pages}{Maximum number of pages to retrieve. Use \code{Inf} to retrieve
all pages (this may take a long time!)}

\item{warn}{If \code{TRUE}, warn when there are unretrieved pages.}
}
\description{
Basic create-read-update-delete verbs for datasets.
}
\section{API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/v2/datasets/get}{get}
\item \href{https://cloud.google.com/bigquery/docs/reference/v2/datasets/insert}{insert}
\item \href{https://cloud.google.com/bigquery/docs/reference/v2/datasets/delete}{delete}
\item \href{https://cloud.google.com/bigquery/docs/reference/v2/tables/list}{list}
}
}

\examples{
if (bq_testable()) {
ds <- bq_dataset(bq_test_project(), "dataset_api")
bq_dataset_exists(ds)

bq_dataset_create(ds)
bq_dataset_exists(ds)
str(bq_dataset_meta(ds))

bq_dataset_delete(ds)
bq_dataset_exists(ds)

# Use bq_test_dataset() to create a temporary dataset that will
# be automatically deleted
ds <- bq_test_dataset()
bq_table_create(bq_table(ds, "x1"))
bq_table_create(bq_table(ds, "x2"))
bq_table_create(bq_table(ds, "x3"))
bq_dataset_tables(ds)
}
}
