% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-driver.r, R/dbi-connection.r,
%   R/dbi-result.r
\docType{class}
\name{DBI}
\alias{DBI}
\alias{BigQueryDriver-class}
\alias{show,BigQueryDriver-method}
\alias{dbConnect,BigQueryDriver-method}
\alias{dbIsValid,BigQueryDriver-method}
\alias{dbGetInfo,BigQueryDriver-method}
\alias{dbDataType,BigQueryDriver-method}
\alias{BigQueryConnection-class}
\alias{show,BigQueryConnection-method}
\alias{dbIsValid,BigQueryConnection-method}
\alias{dbDisconnect,BigQueryConnection-method}
\alias{dbSendQuery,BigQueryConnection,character-method}
\alias{dbQuoteString,BigQueryConnection,character-method}
\alias{dbQuoteIdentifier,BigQueryConnection,character-method}
\alias{dbWriteTable,BigQueryConnection,character,data.frame-method}
\alias{dbReadTable,BigQueryConnection,character-method}
\alias{dbListTables,BigQueryConnection-method}
\alias{dbExistsTable,BigQueryConnection,character-method}
\alias{dbListFields,BigQueryConnection,character-method}
\alias{dbRemoveTable,BigQueryConnection,character-method}
\alias{dbGetInfo,BigQueryConnection-method}
\alias{dbBegin,BigQueryConnection-method}
\alias{dbCommit,BigQueryConnection-method}
\alias{dbRollback,BigQueryConnection-method}
\alias{BigQueryResult-class}
\alias{show,BigQueryResult-method}
\alias{dbIsValid,BigQueryResult-method}
\alias{dbClearResult,BigQueryResult-method}
\alias{dbFetch,BigQueryResult-method}
\alias{dbHasCompleted,BigQueryResult-method}
\alias{dbGetStatement,BigQueryResult-method}
\alias{dbColumnInfo,BigQueryResult-method}
\alias{dbGetRowCount,BigQueryResult-method}
\alias{dbGetRowsAffected,BigQueryResult-method}
\alias{dbBind,BigQueryResult-method}
\title{DBI methods}
\usage{
\S4method{show}{BigQueryDriver}(object)

\S4method{dbConnect}{BigQueryDriver}(drv, project, dataset, billing = project,
  page_size = 10000, quiet = NA, use_legacy_sql = TRUE, ...)

\S4method{dbIsValid}{BigQueryDriver}(dbObj, ...)

\S4method{dbGetInfo}{BigQueryDriver}(dbObj, ...)

\S4method{dbDataType}{BigQueryDriver}(dbObj, obj, ...)

\S4method{show}{BigQueryConnection}(object)

\S4method{dbIsValid}{BigQueryConnection}(dbObj, ...)

\S4method{dbDisconnect}{BigQueryConnection}(conn, ...)

\S4method{dbSendQuery}{BigQueryConnection,character}(conn, statement, ...)

\S4method{dbQuoteString}{BigQueryConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{BigQueryConnection,character}(conn, x, ...)

\S4method{dbWriteTable}{BigQueryConnection,character,data.frame}(conn, name,
  value, overwrite = FALSE, append = FALSE, ..., row.names = NA)

\S4method{dbReadTable}{BigQueryConnection,character}(conn, name, ...,
  row.names = NA)

\S4method{dbListTables}{BigQueryConnection}(conn, ...)

\S4method{dbExistsTable}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbListFields}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbGetInfo}{BigQueryConnection}(dbObj, ...)

\S4method{dbBegin}{BigQueryConnection}(conn, ...)

\S4method{dbCommit}{BigQueryConnection}(conn, ...)

\S4method{dbRollback}{BigQueryConnection}(conn, ...)

\S4method{show}{BigQueryResult}(object)

\S4method{dbIsValid}{BigQueryResult}(dbObj, ...)

\S4method{dbClearResult}{BigQueryResult}(res, ...)

\S4method{dbFetch}{BigQueryResult}(res, n = -1, ..., row.names = NA)

\S4method{dbHasCompleted}{BigQueryResult}(res, ...)

\S4method{dbGetStatement}{BigQueryResult}(res, ...)

\S4method{dbColumnInfo}{BigQueryResult}(res, ...)

\S4method{dbGetRowCount}{BigQueryResult}(res, ...)

\S4method{dbGetRowsAffected}{BigQueryResult}(res, ...)

\S4method{dbBind}{BigQueryResult}(res, params, ...)
}
\arguments{
\item{object}{Any R object}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{project}{The project name, a string}

\item{dataset}{The name of the dataset to create, a string}

\item{billing}{project ID to use for billing}

\item{page_size}{Number of items per page.}

\item{quiet}{if \code{FALSE}, prints informative status messages.}

\item{use_legacy_sql}{(optional) set to \code{FALSE} to enable BigQuery's standard SQL.}

\item{...}{authentication arguments needed by the DBMS instance; these
typically include \code{user}, \code{password}, \code{host}, \code{port}, \code{dbname}, etc.
For details see the appropriate \code{DBIDriver}.}

\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{obj}{An R object whose SQL type we want to determine.}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{x}{A character vector to quote as string.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}.}

\item{append}{a logical specifying whether to append to an existing table
in the DBMS.  Its default is \code{FALSE}.}

\item{row.names}{A logical specifying whether the \code{row.names} should be
output to the output DBMS table; if \code{TRUE}, an extra field whose name
will be whatever the R identifier \code{"row.names"} maps to the DBMS (see
\code{\link[DBI:make.db.names]{DBI::make.db.names()}}). If \code{NA} will add rows names if
they are characters, otherwise will ignore.}

\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{params}{A list of bindings, named or unnamed.}
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package.
}
