% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tabledata.r
\name{list_tabledata}
\alias{list_tabledata}
\alias{list_tabledata_callback}
\title{Retrieve data from a table.}
\usage{
list_tabledata(project, dataset, table, page_size = 10000,
  table_info = NULL, max_pages = 10, warn = TRUE,
  quiet = getOption("bigquery.quiet"))

list_tabledata_callback(project, dataset, table, callback, table_info = NULL,
  page_size = 10000, max_pages = 10, warn = TRUE,
  quiet = getOption("bigquery.quiet"))
}
\arguments{
\item{project}{project containing this table}

\item{dataset}{dataset containing this table}

\item{table}{name of the table}

\item{page_size}{Number of items per page.}

\item{table_info}{if known, the table information retrieved with
\code{\link{get_table}}}

\item{max_pages}{maximum number of pages to retrieve. Use \code{Inf}
to retrieve the complete dataset.}

\item{warn}{If \code{TRUE}, warn when there are rows remaining to
be pulled down from database.}

\item{quiet}{if \code{FALSE}, prints informative status messages.}

\item{callback}{function called with single argument, the data from the
current page of data}
}
\description{
\code{list_tabledata} returns a single dataframe.
\code{list_tabledata_callback} calls the supplied callback with each page
of data.
}
\examples{
\dontrun{
billing_project <- "341409650721" # put your project number here
natal <- list_tabledata("publicdata", "samples", "natality", max_pages = 2,
  page_size = 10)
dim(natal)
}
}
\seealso{
API documentation at
  \url{https://developers.google.com/bigquery/docs/reference/v2/tabledata/list}
}

