% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hergm.R
\name{draw_within_block_connection}
\alias{draw_within_block_connection}
\title{Draw within-block connections}
\usage{
draw_within_block_connection(
  seed_network,
  formula_for_simulation,
  coef_within_block,
  ergm_control,
  output = "network",
  seed,
  n_sim,
  verbose,
  ...
)
}
\arguments{
\item{seed_network}{a seed network from which a network will be simulated.}

\item{formula_for_simulation}{formula for simulating a network}

\item{coef_within_block}{a vector of within-block parameters. The order of the parameters should match that of the formula.}

\item{ergm_control}{auxiliary function as user interface for fine-tuning ERGM simulation}

\item{output}{Normally character, one of "network" (default), "stats", "edgelist", to determine the output format.}

\item{seed}{seed value (integer) for the random number generator.}

\item{n_sim}{Number of networks to be randomly drawn from the given distribution on the set of all networks.}

\item{verbose}{If this is TRUE/1, the program will print out additionalinformation about the progress of simulation.}

\item{...}{Additional arguments, to be passed to lower-level functions}
}
\value{
Simulated within-block connections, the output form depends on the parameter \code{output}.
}
\description{
Draw within-block connections
}
\examples{
data(toyNet)
\donttest{
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") 
draw_within_block_connection(formula_for_simulation = model_formula, 
                             coef_within_block = c(-2,0.1,0.2),
                             ergm_control = control.simulate(),
                             seed_network =toyNet,
                             verbose = TRUE, 
                             output = "edgelist",
                             seed = 123, 
                             n_sim = 1)
}

}
