% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_eco.R
\name{tree_eco}
\alias{tree_eco}
\title{Compute ECO tree}
\usage{
tree_eco(df, topn = 0)
}
\arguments{
\item{df}{data frame containg ECO and Result columns}

\item{topn}{integer, default 0, indicating how many top openings should be included, 0 means show all openings}
}
\value{
Data frame containg White_score (White winning percent), Draws_percent, Black_score and N (number of games). Sorted by power of ECO (White_score * N which describes popularity and score of move) descending.
}
\description{
Compute ECO tree (frequencies and winning percent)
}
\examples{
f <- system.file("extdata", "Kasparov.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,stat.moves = FALSE, add.tags = "ECO")
}
