% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_big_lm.R
\name{predict.bigLm}
\alias{predict.bigLm}
\title{Prediction method for bigLm fitted objects}
\usage{
\method{predict}{bigLm}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{fitted "bigLm" model object}

\item{newdata}{big.matrix object. If NULL, then fitted values are returned}

\item{...}{not used}
}
\value{
An object depending on the type argument
}
\description{
Prediction method for bigLm fitted objects
}
\examples{

library(bigmemory)

nrows <- 50000
ncols <- 50
bkFile <- "bigmat3.bk"
descFile <- "bigmatk3.desc"
bigmat <- filebacked.big.matrix(nrow=nrows, ncol=ncols, type="double",
                                backingfile=bkFile, backingpath=".",
                                descriptorfile=descFile,
                                dimnames=c(NULL,NULL))

# Each column value with be the column number multiplied by
# samples from a standard normal distribution.
set.seed(123)
for (i in 1:ncols) bigmat[,i] = rnorm(nrows)*i

y <- rnorm(nrows) + bigmat[,1]

system.time(lmr1 <- bigLm(bigmat, y))


preds <- predict(lmr1, newdata = bigmat)

}

