% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{getScaffoldsWithThisType}
\alias{getScaffoldsWithThisType}
\title{Getting all scaffolds classified as a specific scaffold type}
\usage{
getScaffoldsWithThisType(object, type, threshold_certainty = 0.9)
}
\arguments{
\item{object}{A bexy object.}

\item{type}{One specific scaffold type, can be Autosome, Y-linked, X-linked or Different.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All scaffolds that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
A character vector containing all scaffold names that are classified as the scaffold type given by argument 'type'.
}
\description{
Getting all scaffolds classified as a specific scaffold type
}
\examples{
bex <- bexy()
getScaffoldsWithThisType(bex, "X-linked")
}
\seealso{
\code{\link{bexy}}
}
