% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{getSamplesWithThisKaryotype}
\alias{getSamplesWithThisKaryotype}
\title{Getting all samples classified as a specific sex karyotype}
\usage{
getSamplesWithThisKaryotype(object, karyotype, threshold_certainty = 0.9)
}
\arguments{
\item{object}{A bexy object.}

\item{karyotype}{One specific sex karyotype, can be XY, XX, X0, XXY, XYY, XXX or XXYY.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All samples that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
A character vector containing all sample names that are classified as the sex karyotype given by argument 'karyotype'.
}
\description{
Getting all samples classified as a specific sex karyotype
}
\examples{
bex <- bexy()
getSamplesWithThisKaryotype(bex, "XX")
}
\seealso{
\code{\link{bexy}}
}
