% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{Lords.k}
\alias{Lords.k}
\title{Function for estimating "Lord's k" for Lord's two-term approximation to the compound binomial distribution.}
\usage{
Lords.k(x, N, reliability)
}
\arguments{
\item{x}{A vector of observed-scores.}

\item{N}{The test length.}

\item{reliability}{The test-score reliability coefficient.}
}
\value{
A value representing Lord's k
}
\description{
Calculates Lord's k.
}
\examples{
# Generate some fictional data. Say 100 students take a 50-item long test
# where all items are equally difficult (i.e., where the true Lord's k = 0).
set.seed(1234)
p.success <- rBeta.4P(100, 0.25, 0.75, 5, 3)
for (i in 1:50) {
  if (i == 1) {
    rawdata <- matrix(nrow = 100, ncol = 50)
  }
  rawdata[, i] <- rbinom(100, 1, p.success)
}

# Estimate the reliability of these scores with Cronbach's Alpha:
reliability <- cba(rawdata)

# Estimate Lord's k using Lords.k():
Lords.k(rowSums(rawdata), 50, reliability)
}
