% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bsrr.R
\name{plot.bsrr}
\alias{plot.bsrr}
\title{Produces a coefficient profile plot of the coefficient or loss function
paths}
\usage{
\method{plot}{bsrr}(
  x,
  type = c("tune", "coefficients"),
  lambda = NULL,
  sign.lambda = 0,
  breaks = T,
  K = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{"bsrr"} object.}

\item{type}{One of \code{"tune"}, \code{"coefficients"}, \code{"both"}.
For \code{"bsrr"} with \eqn{L_2} shrinkage:
If (\code{type = "tune"}), the path of corresponding information criterion
or cross-validation loss is provided;
If \code{type = "coefficients"}, a lambda should be provided and and this funciton provides a coefficient profile plot of the coefficient;
For \code{"bsrr"} object without \eqn{L_2} shrinkage:
If \code{type = "tune"}, a path of lcorresponding information criterion or cross-validation loss is provided.
If \code{type = "coefficients"}, it provides a coefficient profile plot of the coefficient.}

\item{lambda}{For \code{"bsrr"} with \eqn{L_2} shrinkage: To plot the change of coefficients with lambda equals this value for \code{type = "coefficients"} or \code{type = "both"}.}

\item{sign.lambda}{For \code{"bsrr"} with \eqn{L_2} shrinkage: A logical value indicating whether to show lambda on log scale. Default is 0.}

\item{breaks}{For \code{"bsrr"} object without \eqn{L_2} shrinkage: If \code{TRUE}, a vertical line is drawn at a specified break point in
the coefficient paths.}

\item{K}{For \code{"bsrr"} object without \eqn{L_2} shrinkage: Which break point should the vertical line be drawn at. Default is the optimal model size.}

\item{\dots}{Other graphical parameters to plot}
}
\value{
No return value, called for plots generation
}
\description{
Produces a coefficient profile plot of the coefficient or loss function
paths
}
\examples{

# Generate simulated data
n <- 200
p <- 20
k <- 5
rho <- 0.4
seed <- 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data <- gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed = seed)
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr <- bsrr(Data$x, Data$y, method = "pgsection")

# generate plots
plot(lm.bsrr)

}
\seealso{
\code{\link{bsrr}}.
}
\author{
Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu, Canhong Wen and Xueqin Wang.
}
