% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarize.R
\name{binarize}
\alias{binarize}
\alias{predict.binarize}
\alias{print.binarize}
\title{Binarize}
\usage{
binarize(x, location_measure = "median")

\method{predict}{binarize}(object, newdata = NULL, inverse = FALSE,
  ...)

\method{print}{binarize}(x, ...)
}
\arguments{
\item{x}{A vector to binarize}

\item{location_measure}{which location measure should be used? can either be
"median", "mean", "mode", a number, or a function.}

\item{object}{an object of class 'binarize'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}

\item{...}{additional arguments}
}
\value{
A list of class \code{binarize} with elements 
  \item{x.t}{transformed original data} 
  \item{x}{original data} 
  \item{method}{location_measure used for original fitting} 
  \item{location}{estimated location_measure} 
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom}
  
  The \code{predict} function with \code{inverse = FALSE} returns the numeric
  value (0 or 1) of the transformation on \code{newdata} (which defaults to
  the original data).
  
  If \code{inverse = TRUE}, since the transform is not 1-1, it will create
  and return a factor that indicates where the original data was cut.
}
\description{
This function will perform a binarizing transformation, which
  could be used as a last resort if the data cannot be adequately normalized.
  This may be useful when accidentally attempting normalization of a binary
  vector (which could occur if implementing bestNormalize in an automated
  fashion).
  
  Note that the transformation is not one-to-one, in contrast to the other
  functions in this package.
}
\examples{
x <- rgamma(100, 1, 1)
binarize_obj <- binarize(x)
(p <- predict(binarize_obj))

predict(binarize_obj, newdata = p, inverse = TRUE)
}
