% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funSource.R
\name{funSource}
\alias{funSource}
\title{Source code of a function}
\usage{
funSource(x, character.only = is.character(x), local = FALSE)
}
\arguments{
\item{x}{function name, with or without quotation marks}

\item{character.only}{If TRUE, look for SomeFun instead of MyFun if
MyFun <- "SomeFun". DEFAULT: \code{\link{is.character}(x)}}

\item{local}{Open offline version of the code? Lacks comments and
original formatting of source code. DEFAULT: FALSE}
}
\value{
links that are also opened with \code{\link{browseURL}}
}
\description{
open source code of a function in a loaded or specified package on github.com/cran or github.com/wch/r-source
}
\examples{
\dontrun{ ## browser windows should not be opened in CRAN checks
library("berryFunctions")
funSource(colPoints)
funSource("head")
funSource("require", local=TRUE) # usefull when offline

funSource("OSMscale::earthDist") # works even for non-installed CRAN packages
}

\dontrun{ # developmental testing
is.error(funSource("earthDist"), TRUE, TRUE) # Error for unloaded package
require(plotrix); require(scales)
funSource(rescale) # from the last loaded package

tail <- function(...) stop("This is a dummy function. Type: rm(tail)")
funSource("tail")
rm(tail)
}

}
\seealso{
\url{https://github.com/brry/rskey#rskey} to add this as a keyboard shortcut
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan+Dec 2016
}
