% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_model.R
\name{create_clock_model}
\alias{create_clock_model}
\title{General function to create a clock model}
\usage{
create_clock_model(name, id, ...)
}
\arguments{
\item{name}{the clock model name. Valid
names can be found in \code{\link{get_clock_model_names}}}

\item{id}{a clock model's ID}

\item{...}{specific clock model parameters}
}
\value{
a valid clock model
}
\description{
General function to create a clock model
}
\note{
Prefer using the named function
  \code{\link{create_rln_clock_model}}
  and \code{\link{create_strict_clock_model}}
}
\examples{
  rln_clock_model <- create_rln_clock_model()

  create_beast2_input_file(
    get_fasta_filename(),
    "create_clock_model_rln.xml",
    clock_models = rln_clock_model
  )
  testit::assert(file.exists("create_clock_model_rln.xml"))

  strict_clock_model <- create_strict_clock_model()

  create_beast2_input_file(
    get_fasta_filename(),
    "create_clock_model_strict.xml",
    clock_models = strict_clock_model
  )
  testit::assert(file.exists("create_clock_model_strict.xml"))
}
\seealso{
An alignment ID can be extracted from
  its FASTA filesname using \code{\link{get_id}}.
  For more examples about creating a relaxed log-normal clock
  model, see \code{\link{create_rln_clock_model}}.
  For more examples about creating a strict clock
  model, see \code{\link{create_strict_clock_model}}.
}
\author{
Richel J.C. Bilderbeek
}
