% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_cep_tree_prior}
\alias{create_cep_tree_prior}
\alias{create_tree_prior_cep}
\title{Create a Coalescent Exponential Population tree prior}
\usage{
create_cep_tree_prior(id = NA, pop_size_distr = create_one_div_x_distr(),
  growth_rate_distr = create_laplace_distr())
}
\arguments{
\item{id}{the ID of the alignment}

\item{pop_size_distr}{the population distribution,
as created by a \code{\link{create_distr}} function}

\item{growth_rate_distr}{the growth rate distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a Coalescent Exponential Population tree_prior
}
\description{
Create a Coalescent Exponential Population tree prior
}
\examples{
  cep_tree_prior <- create_cep_tree_prior()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_cep_tree_prior.xml",
    tree_priors = cep_tree_prior
  )
  testit::assert(file.exists("create_cep_tree_prior.xml"))
}
\seealso{
An alignment ID can be extracted from
  its FASTA filesname using \code{\link{get_id}}
}
\author{
Richel J.C. Bilderbeek
}
