% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_file_1_12.R
\name{create_beast2_input_file_1_12}
\alias{create_beast2_input_file_1_12}
\title{Create a BEAST2 input file, interface of v1.12.
This interface is obsoleted, use \code{\link{create_beast2_input_file}}
instead}
\usage{
create_beast2_input_file_1_12(input_filenames, output_filename,
  site_models = create_jc69_site_models(ids = get_ids(input_filenames)),
  clock_models = create_strict_clock_models(ids = get_ids(input_filenames)),
  tree_priors = create_yule_tree_priors(ids = get_ids(input_filenames)),
  mcmc = create_mcmc(), fixed_crown_ages = rep(FALSE,
  length(input_filenames)), initial_phylogenies = rep(NA,
  length(input_filenames)))
}
\arguments{
\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mcmc}{one mcmc object,
as returned by \code{\link{create_mcmc}}}

\item{fixed_crown_ages}{one or more booleans to determine if the
phylogenies' crown ages are fixed.
If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{initial_phylogenies}{one or more MCMC chain's initial phylogenies.
Each one set to NA will result in BEAST2 using a random phylogeny. Else
the phylogeny is assumed to be of class ape::phylo.}
}
\description{
Create a BEAST2 input file, interface of v1.12.
This interface is obsoleted, use \code{\link{create_beast2_input_file}}
instead
}
\examples{
  # The file created by beautier, a BEAST2 input file
  output_filename_fixed <- "create_beast2_input_file_1_12.xml"

  # Birth-Death tree prior, crown age is fixed at 15 time units
  create_beast2_input_file_1_12(
    input_filenames = get_fasta_filename(),
    output_filename = output_filename_fixed,
    fixed_crown_ages = TRUE,
    initial_phylogenies = beautier::fasta_to_phylo(
      fasta_filename = get_fasta_filename(),
      crown_age = 15)
  )
  testthat::expect_true(file.exists(output_filename_fixed))
}
\seealso{
See \code{\link{create_site_model}} for examples with
  different site models. See \code{\link{create_clock_model}} for examples
  with clock models. See \code{\link{create_tree_prior}} for examples with
  different tree priors. See \code{\link{create_mcmc}} for examples with
  a different MCMC setup. See \code{\link{fasta_to_phylo}} for examples with
  a fixed crown age
}
\author{
Richel J.C. Bilderbeek
}
