% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Router.R
\name{Router}
\alias{Router}
\title{Router Class}
\description{
A \code{Router} object represents the handling of routing and middleware
(such as httpGET(), httpPUT(), httpPOST(), and so on). Once a \code{Router}
object is instantiated, middleware and HTTP method routes can be added. The
top level \code{Beakr} object initializes with the creation of a
\code{Router} object.
}
\section{Fields}{


\describe{
  \item{\code{middleware}}{
  A list of specified middleware function or functions.
  }
  \item{\code{listeners}}{
  A list of specified listeners.
  }
}
}

\section{Methods}{


\describe{
\item{\code{addMiddleware(middlware)}}{
  A method to add middleware function(s) to \code{middleware}.
  }
  \item{\code{addListener(listener)}}{
  A method to add listeners to \code{listeners}.
  }
  \item{\code{processEvent(event, ...)}}{
  Processes the event heard by the \code{Listener}.
  }
  \item{\code{invoke(req, websocket_msg, websocket_binary)}}{
  This method is used to create the request-response cycle objects of the
  provided middleware.
  }
}
}

\seealso{
\code{\link{Response}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-addMiddleware}{\code{Router$addMiddleware()}}
\item \href{#method-addListener}{\code{Router$addListener()}}
\item \href{#method-processEvent}{\code{Router$processEvent()}}
\item \href{#method-invoke}{\code{Router$invoke()}}
\item \href{#method-clone}{\code{Router$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addMiddleware"></a>}}
\subsection{Method \code{addMiddleware()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$addMiddleware(middleware)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addListener"></a>}}
\subsection{Method \code{addListener()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$addListener(listener)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-processEvent"></a>}}
\subsection{Method \code{processEvent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$processEvent(event, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invoke"></a>}}
\subsection{Method \code{invoke()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$invoke(req, websocket_msg = NULL, websocket_binary = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
