% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_summary_col.R
\name{bdc_summary_col}
\alias{bdc_summary_col}
\title{Create or update the column summarizing the results of data quality tests}
\usage{
bdc_summary_col(data)
}
\arguments{
\item{data}{data.frame. Containing the results of data quality tests (i.e.,
columns starting with ".").}
}
\value{
A data.frame containing a new or an updated column ".summary".
}
\description{
This function creates or updates the column ".summary" summarizing the
results of data quality tests (i.e., columns starting with "."). Records that
have failed in at least one test are flagged for further inspection (i.e.,
flagged as "FALSE") in the ".summary" column.
}
\details{
If existing, the column ".summary" will be removed and then updated
considering all test names available in the supplied database.
}
\examples{
.missing_names <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
.missing_coordinates <- c(TRUE, FALSE, FALSE, TRUE, FALSE)
x <- data.frame(.missing_names, .missing_coordinates)

bdc_summary_col(data = x)

}
