% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{sufficientStatistics}
\alias{sufficientStatistics}
\title{Get sample sufficient statistics}
\usage{
sufficientStatistics(obj, x, ...)
}
\arguments{
\item{obj}{a "BayesianBrick" object used to select a method.}

\item{x}{a set of samples.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of corresponding sufficient statistics class, such as "ssGaussian"
}
\description{
This is a generic function that will generate the sufficient statistics of a given Bayesian bricks object. i.e. \cr
for the model structure:
     \deqn{theta|gamma \sim H(gamma)}
     \deqn{x|theta \sim F(theta)}
get the sufficient statistics T(x). \cr
For a given sample set x, each row of x is an observation, and a Bayesian bricks object obj. \code{sufficientStatistics()} return the sufficient statistics for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
The sufficient statistics are:
\itemize{
 \item   SA = \eqn{sum_{i=1:N} A_i^T Sigma^{-1} A_i}
 \item  SAx = \eqn{sum_{i=1:N} A_i^T Sigma^{-1} (x_i-b_i)}
}
See \code{?sufficientStatistics.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{mu \sim Gaussian(m,S)}
Sigma is known.
The sufficient statistics are:
\itemize{
\item N: the effective number of samples.
\item xsum: the row sums of the samples.
}
See \code{?sufficientStatistics.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
mu is known. \cr
The sufficient statistics are:
\itemize{
\item N: the effective number of samples.
\item xsum: the sample scatter matrix centered on the mean vector.
}
See \code{?sufficientStatistics.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
\deqn{mu \sim Gaussian(m,Sigma/k)}
The sufficient statistics are:
\itemize{
\item N: the effective number of samples.
\item xsum: the row sums of the samples.
\item S: the uncentered sample scatter matrix.
}
See \code{?sufficientStatistics.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x \sim Gaussian(X beta,sigma^2)}
\deqn{sigma^2 \sim InvGamma(a,b)}
\deqn{beta \sim Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
The sufficient statistics are:
\itemize{
\item N: the effective number of samples.
\item SXx: covariance of X and x
\item SX: the uncentered sample scatter matrix.
\item Sx: the variance of x
}
See \code{?sufficientStatistics.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim Dirichlet(alpha)}
The sufficient statistics of CatDirichlet object can either be x itself, or the counts of the unique labels in x.\cr
See \code{?sufficientStatistics.CatDirichlet} for details.
}
\subsection{class(obj)="CatDP"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim DirichletProcess(alpha)}
The sufficient statistics of CatDP object can either be x itself, or the counts of the unique labels in x.\cr
See \code{?sufficientStatistics.CatDP} for details.
}
\subsection{class(obj)="DP"}{
Where
     \deqn{pi|alpha \sim DP(alpha,U)}
    \deqn{z|pi \sim Categorical(pi)}
     \deqn{theta_z|psi \sim H0(psi)}
     \deqn{x|theta_z,z \sim F(theta_z)}
The sufficient statistics of "DP" object is the same sufficient statistics of the "BasicBayesian" inside the "DP".
See \code{?sufficientStatistics.DP} for details.
}
\subsection{class(obj)="HDP"}{
Where
     \deqn{G|gamma \sim DP(gamma,U)}
     \deqn{pi_j|G,alpha \sim DP(alpha,G), j = 1:J}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G \sim Categorical(G),\textrm{ if z is a sample from the base measure G}}
     \deqn{theta_k|psi \sim H0(psi)}
The sufficient statistics of "HDP" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP".
See \code{?sufficientStatistics.HDP} for details.
}
\subsection{class(obj)="HDP2"}{
Where
     \deqn{G |eta \sim DP(eta,U)}
     \deqn{G_m|gamma,G \sim DP(gamma,G), m = 1:M}
     \deqn{pi_{mj}|G_m,alpha \sim DP(alpha,G_m), j = 1:J_m}
     \deqn{z|pi_{mj} \sim Categorical(pi_{mj})}
     \deqn{k|z,G_m \sim Categorical(G_m),\textrm{ if z is a sample from the base measure} G_m}
     \deqn{u|k,G \sim Categorical(G),\textrm{ if k is a sample from the base measure} G}
     \deqn{theta_u|psi \sim H0(psi)}
     \deqn{x|theta_u,u \sim F(theta_u)}
The sufficient statistics of "HDP2" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP2".
See \code{?sufficientStatistics.HDP2} for details.
}
}
\examples{
x <- rGaussian(10,mu = 1,Sigma = 1)
obj <- GaussianNIW()                    #an GaussianNIW object
sufficientStatistics(obj=obj,x=x)
}
\seealso{
\code{\link{sufficientStatistics.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{sufficientStatistics.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{sufficientStatistics.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{sufficientStatistics.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{sufficientStatistics.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{sufficientStatistics.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{sufficientStatistics.CatDP}} for Categorical-DP conjugate structure ...
}
