% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{rPosteriorPredictive.CatDirichlet}
\alias{rPosteriorPredictive.CatDirichlet}
\title{Generate random samples from the posterior predictive distribution of a "CatDirichlet" object}
\usage{
\method{rPosteriorPredictive}{CatDirichlet}(obj, n, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{n}{integer, number of samples.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A vector of the same type as obj$gamma$uniqueLabels.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{pi|alpha \sim Dir(alpha)}
     \deqn{x|pi \sim Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object \cr
posterior predictive is a distribution of x|alpha
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
rPosteriorPredictive(obj=obj,n=200)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{dPosteriorPredictive.CatDirichlet}}
}
