% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posterior.CatHDP2}
\alias{posterior.CatHDP2}
\title{Update a "CatHDP2" object with sample sufficient statistics}
\usage{
\method{posterior}{CatHDP2}(obj, ss1, ss2, ss3, m, j, w = NULL, ...)
}
\arguments{
\item{obj}{A "CatHDP2" object.}

\item{ss1}{Sufficient statistics of u. In CatHDP2 case the sufficient statistic of sample u is u itself(if u is a integer vector with all positive values).}

\item{ss2}{Sufficient statistics of k. In CatHDP2 case the sufficient statistic of sample k is k itself(if k is a integer vector with all positive values).}

\item{ss3}{Sufficient statistics of z. In CatHDP2 case the sufficient statistic of sample z is z itself(if z is a integer vector with all positive values).}

\item{m}{integer, group label.}

\item{j}{integer, subgroup label.}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss1" and "ss2".
}
\description{
For the model structure:
     \deqn{G_m |eta \sim DP(eta,U), m = 1:M}
     \deqn{G_mj|gamma \sim DP(gamma,G_m), j = 1:J_m}
     \deqn{pi_mj|G_mj,alpha \sim DP(alpha,G_mj)}
     \deqn{z|pi_mj \sim Categorical(pi_mj)}
     \deqn{k|z,G_mj \sim Categorical(G_mj), if z is a sample from the base measure G_mj}
     \deqn{u|k,G_m \sim Categorical(G_m), if k is a sample from the base measure G_m}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_m) is a Dirichlet Process on integers with concentration parameter gamma and base measure G_m. DP(alpha,G_mj) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_mj. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP2, u, z and k can only be positive integers. \cr
Update the prior knowledge by adding the information of newly observed samples u, z and k. The model structure and prior parameters are stored in a "CatHDP2" object, the prior parameters in this object will be updated after running this function.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP2}},\code{\link{posteriorDiscard.CatHDP2}}
}
