% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{dPosteriorPredictive.CatDirichlet}
\alias{dPosteriorPredictive.CatDirichlet}
\title{Posterior predictive density function of a "CatDirichlet" object}
\usage{
\method{dPosteriorPredictive}{CatDirichlet}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{x}{numeric/integer/character vector, observed Categorical samples.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{pi|alpha \sim Dir(alpha)}
     \deqn{x|pi \sim Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object. \cr
Posterior predictive is a distribution of x|alpha.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
## res1 and res2 should provide the same result
res1 <- dPosteriorPredictive(obj = obj,x=x,LOG = TRUE)
res2 <- numeric(length(x))
for(i in seq_along(x)) res2[i] <- marginalLikelihood(obj=obj,x=x[i],LOG = TRUE)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{dPosteriorPredictive.CatDirichlet}}, \code{\link{marginalLikelihood.CatDirichlet}}
}
