% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosterior.GaussianNIW}
\alias{dPosterior.GaussianNIW}
\title{Density function of the posterior distribution of a "GaussianNIW" object}
\usage{
\method{dPosterior}{GaussianNIW}(obj, mu, Sigma, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{mu}{vector.}

\item{Sigma}{matrix, nrow(Sigma) = length(mu).}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the posterior density of (mu,Sigma).
}
\description{
Generate the the density value of the posterior distribution of the following structure:
     \deqn{mu,Sigma|m,k,v,S \sim NIW(m,k,v,S)}
     \deqn{x|mu,Sigma \sim Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
Posterior density is the density function of NIW(mu,Sigma|m,k,v,S).
}
\examples{
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
mu <- rnorm(2)
Sigma <- rInvWishart(df = 3,scale = diag(2))
dPosterior(obj = obj,mu=mu,Sigma = Sigma)
}
\seealso{
\code{\link{GaussianNIW}}, \code{\link{rPosterior.GaussianNIW}}
}
