% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posteriorDiscard.LinearGaussianGaussian}
\alias{posteriorDiscard.LinearGaussianGaussian}
\title{Update a "LinearGaussianGaussian" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{LinearGaussianGaussian}(obj, ss, ...)
}
\arguments{
\item{obj}{A "LinearGaussianGaussian" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-Gaussian case the sufficient statistic of sample x is a object of type "ssLinearGaussianGaussian", it can be generated by the function sufficientStatistics().}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated based on "ss".
}
\description{
For following model structure:
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
Where Sigma is known. A is a \eqn{dimx x dimz} matrix, x is a \eqn{dimx x 1} random vector, z is a \eqn{dimz x 1} random vector, b is a \eqn{dimm x 1} vector. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
Contrary to posterior(), this function will update (m,S) by removing the information of observed samples x. The model structure and prior parameters are stored in a "LinearGaussianGaussian" object, the prior parameters in this object will be updated after running this function.
}
\examples{
obj <- LinearGaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),
                              m=c(0.2,0.5,0.6),S=diag(3)))
x <- rGaussian(100,mu = runif(2),Sigma = diag(2))
A <- matrix(runif(6),2,3)
b <- runif(2)
ss <- sufficientStatistics(obj,x=x,A=A,b=b)
obj
## update prior into posterior
posterior(obj=obj,ss=ss)
obj
## remove the information, back to prior
posteriorDiscard(obj = obj,ss = ss)
obj
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{LinearGaussianGaussian}},\code{\link{posterior.LinearGaussianGaussian}},\code{\link{sufficientStatistics.LinearGaussianGaussian}}
}
