% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{GaussianNIG}
\alias{GaussianNIG}
\title{Create objects of type "GaussianNIG".}
\usage{
GaussianNIG(
  objCopy = NULL,
  ENV = parent.frame(),
  gamma = list(m = 0, V = 1, a = 1, b = 1)
)
}
\arguments{
\item{objCopy}{An object of type "GaussianNIG". If "objCopy" is not NULL, the function create a new "GaussianNIG" object by copying the content from objCopy, otherwise this new object will be created by using "ENV" and "gamma". Default NULL.}

\item{ENV}{environment, specify in which environment the object will be created}

\item{gamma}{list, a named list of NIG parameters, gamma=list(m,V,a,b). Where gamma$m is a numeric "location" parameter; gamma$V is a symmetric positive definite matrix representing the "scale" parameters; gamma$a and gamma$b are the "shape" and "scale" parameter of the Inverse Gamma distribution.}
}
\value{
An object of class "GaussianNIG".
}
\description{
Create an object of type "GaussianNIG", which represents the Gaussian and Normal-Inverse-Gamma (Gaussian-NIG) conjugate structure:
   \deqn{x ~ Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 ~ InvGamma(a,b)}
   \deqn{beta ~ Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
This object will be used as a place for recording and accumulating information in the related inference/sampling functions such as posterior(), posteriorDiscard(), MAP(), marginalLikelihood(), dPosteriorPredictive(), rPosteriorPredictive() and so on.
}
\examples{
\donttest{
X <- 1:20                               #generate some linear data
x <- rnorm(20)+ X*0.3                   #generate some linear data
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=0)) #create a GaussianNIG object
ss <- sufficientStatistics(obj = obj,X=X,x=x)   #the sufficient statistics of X and x
posterior(obj = obj,ss = ss)                    #add the infomation to the posterior
MAP(obj)                                        #get the MAP estimate of beta and sigma^2
## print the whole content, "invV" and "mVm" in the output are temporary variables.
obj
}
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{posterior.GaussianNIG}},\code{\link{posteriorDiscard.GaussianNIG}},\code{\link{MAP.GaussianNIG}},\code{\link{MPE.GaussianNIG}},\code{\link{marginalLikelihood.GaussianNIG}},\code{\link{dPosteriorPredictive.GaussianNIG}}, \code{\link{rPosteriorPredictive.GaussianNIG}} ...
}
