% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc-censoring.R
\name{PPC-censoring}
\alias{PPC-censoring}
\alias{ppc_km_overlay}
\title{PPC censoring}
\usage{
ppc_km_overlay(y, yrep, ..., status_y, size = 0.25, alpha = 0.7)
}
\arguments{
\item{y}{A vector of observations. See \strong{Details}.}

\item{yrep}{An \eqn{S} by \eqn{N} matrix of draws from the posterior
predictive distribution, where \eqn{S} is the size of the posterior sample
(or subset of the posterior sample used to generate \code{yrep}) and \eqn{N} is
the number of observations (the length of \code{y}). The columns of \code{yrep}
should be in the same order as the data points in \code{y} for the plots to make
sense. See \strong{Details} for additional instructions.}

\item{...}{Currently unused.}

\item{status_y}{The status indicator for the observations from \code{y}. This must
be a numeric vector of the same length as \code{y} with values in \{0, 1\} (0 =
right censored, 1 = event).}

\item{size, alpha}{Passed to the appropriate geom to control the appearance of
the \code{yrep} distributions.}
}
\value{
A ggplot object that can be further customized using the \strong{ggplot2} package.
}
\description{
Compare the empirical distribution of censored data \code{y} to the
distributions of simulated/replicated data \code{yrep} from the posterior
predictive distribution. See the \strong{Plot Descriptions} section, below, for
details.

Although some of the other \pkg{bayesplot} plots can be used with censored
data, \code{ppc_km_overlay()} is currently the only plotting function designed
\emph{specifically} for censored data. We encourage you to suggest or contribute
additional plots at
\href{https://github.com/stan-dev/bayesplot}{github.com/stan-dev/bayesplot}.
}
\section{Plot Descriptions}{

\describe{
\item{\code{ppc_km_overlay()}}{
Empirical CCDF estimates of each dataset (row) in \code{yrep} are overlaid,
with the Kaplan-Meier estimate (Kaplan and Meier, 1958) for \code{y} itself on
top (and in a darker shade). This is a PPC suitable for right-censored
\code{y}. Note that the replicated data from \code{yrep} is assumed to be
uncensored.
}
}
}

\examples{
color_scheme_set("brightblue")
y <- example_y_data()
# For illustrative purposes, (right-)censor values y > 110:
status_y <- as.numeric(y <= 110)
y <- pmin(y, 110)
# In reality, the replicated data (yrep) would be obtained from a
# model which takes the censoring of y properly into account. Here,
# for illustrative purposes, we simply use example_yrep_draws():
yrep <- example_yrep_draws()
dim(yrep)
\donttest{
ppc_km_overlay(y, yrep[1:25, ], status_y = status_y)
}
}
\references{
Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari,
A., and Rubin, D. B. (2013). \emph{Bayesian Data Analysis.} Chapman & Hall/CRC
Press, London, third edition. (Ch. 6)

Kaplan, E. L. and Meier, P. (1958). Nonparametric estimation
from incomplete observations.
\emph{Journal of the American Statistical Association}. 53(282), 457--481.
doi:10.1080/01621459.1958.10501452.
}
\seealso{
Other PPCs: 
\code{\link{PPC-discrete}},
\code{\link{PPC-distributions}},
\code{\link{PPC-errors}},
\code{\link{PPC-intervals}},
\code{\link{PPC-loo}},
\code{\link{PPC-overview}},
\code{\link{PPC-scatterplots}},
\code{\link{PPC-test-statistics}}
}
\concept{PPCs}
