\name{rmvst}
\alias{rmvst}
\title{ Draw from Multivariate Student-t }
\description{
  \code{rmvst} draws from a Multivariate student-t distribution.
}
\usage{
rmvst(nu, mu, root)
}
\arguments{
  \item{nu}{ d.f. parameter }
  \item{mu}{ mean vector }
  \item{root}{ Upper Tri Cholesky Root of Sigma }
}
\value{
  length(mu) draw vector
}
\references{ For further discussion, see \emph{Bayesian Statistics and Marketing}
  by Allenby, McCulloch, and Rossi. \cr
  \url{http://gsbwww.uchicago.edu/fac/peter.rossi/research/bsm.html}
}

\author{ Peter Rossi, Graduate School of Business, University of Chicago,
  \email{Peter.Rossi@ChicagoGsb.edu}.
}

\section{Warning}{
  This routine is a utility routine that does \strong{not} check the
  input arguments for proper dimensions and type.
}

\seealso{ \code{\link{lndMvst}}}
\examples{
##
set.seed(66)
rmvst(nu=5,mu=c(rep(0,2)),root=chol(matrix(c(2,1,1,2),ncol=2)))
}
\keyword{ distribution }
