% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{bayesian}
\alias{bayesian}
\alias{update.bayesian}
\alias{bayesian_fit}
\alias{bayesian_formula}
\alias{bayesian_terms}
\alias{bayesian_family}
\alias{bayesian_predict}
\alias{bayesian_write}
\alias{bayesian_read}
\title{General Interface for Bayesian TidyModels}
\usage{
bayesian(
  mode = "regression",
  engine = "brms",
  formula.override = NULL,
  family = NULL,
  prior = NULL,
  sample_prior = NULL,
  knots = NULL,
  stanvars = NULL,
  fit = NULL,
  inits = NULL,
  chains = NULL,
  iter = NULL,
  warmup = NULL,
  thin = NULL,
  cores = NULL,
  threads = NULL,
  algorithm = NULL,
  backend = NULL,
  stan_args = NULL,
  control = NULL,
  save_pars = NULL,
  save_model = NULL,
  file = NULL,
  file_refit = NULL,
  normalize = NULL,
  future = NULL,
  seed = NULL,
  silent = NULL
)

\method{update}{bayesian}(
  object,
  parameters = NULL,
  formula.override = NULL,
  family = NULL,
  prior = NULL,
  sample_prior = NULL,
  knots = NULL,
  stanvars = NULL,
  fit = NULL,
  inits = NULL,
  chains = NULL,
  iter = NULL,
  warmup = NULL,
  thin = NULL,
  cores = NULL,
  threads = NULL,
  algorithm = NULL,
  backend = NULL,
  stan_args = NULL,
  control = NULL,
  save_pars = NULL,
  save_model = NULL,
  file = NULL,
  file_refit = NULL,
  normalize = NULL,
  future = NULL,
  seed = NULL,
  silent = NULL,
  fresh = FALSE,
  ...
)

bayesian_fit(formula, data, ...)

bayesian_formula(formula, ...)

bayesian_terms(formula, ...)

bayesian_family(family, ...)

bayesian_predict(object, ...)

bayesian_write(object, file)

bayesian_read(file)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational
engine to use for fitting. Possible engines are listed below.
The default for this model is \code{"brms"}.}

\item{formula.override}{Overrides the formula; for details see
\code{\link[brms]{brmsformula}}.}

\item{family}{A description of the response distribution and link function to
be used in the model. This can be a family function, a call to a family
function or a character string naming the family. Every family function has
a \code{link} argument allowing to specify the link function to be applied
on the response variable. If not specified, default links are used. For
details of supported families see \code{\link[brms]{brmsfamily}}. By default, a
linear \code{gaussian} model is applied. In multivariate models,
\code{family} might also be a list of families.}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link[brms]{set_prior}} or related functions and combined using the
\code{c} method or the \code{+} operator. See also  \code{\link[brms]{get_prior}}
for more help.}

\item{sample_prior}{Indicate if draws from priors should be drawn
additionally to the posterior draws. Options are \code{"no"} (the
default), \code{"yes"}, and \code{"only"}. Among others, these draws can
be used to calculate Bayes factors for point hypotheses via
\code{\link[brms]{hypothesis}}. Please note that improper priors are not sampled,
including the default improper priors used by \code{brm}. See
\code{\link[brms]{set_prior}} on how to set (proper) priors. Please also note
that prior draws for the overall intercept are not obtained by default
for technical reasons. See \code{\link[brms]{brmsformula}} how to obtain prior
draws for the intercept. If \code{sample_prior} is set to \code{"only"},
draws are drawn solely from the priors ignoring the likelihood, which
allows among others to generate draws from the prior predictive
distribution. In this case, all parameters must have proper priors.}

\item{knots}{Optional list containing user specified knot values to be used
for basis construction of smoothing terms. See
\code{\link[mgcv:gamm]{gamm}} for more details.}

\item{stanvars}{An optional \code{stanvars} object generated by function
\code{\link[brms]{stanvar}} to define additional variables for use in
\pkg{Stan}'s program blocks.}

\item{fit}{An instance of S3 class \code{brmsfit} derived from a previous
fit; defaults to \code{NA}. If \code{fit} is of class \code{brmsfit}, the
compiled model associated with the fitted result is re-used and all
arguments modifying the model code or data are ignored. It is not
recommended to use this argument directly, but to call the
\code{\link[brms:update.brmsfit]{update}} method, instead.}

\item{inits}{Either \code{"random"} or \code{"0"}. If inits is
\code{"random"} (the default), Stan will randomly generate initial values
for parameters. If it is \code{"0"}, all parameters are initialized to
zero. This option is sometimes useful for certain families, as it happens
that default (\code{"random"}) inits cause draws to be essentially
constant. Generally, setting \code{inits = "0"} is worth a try, if chains
do not behave well. Alternatively, \code{inits} can be a list of lists
containing the initial values, or a function (or function name) generating
initial values. The latter options are mainly implemented for internal
testing but are available to users if necessary. If specifying initial 
values using a list or a function then currently the parameter names must
correspond to the names used in the generated Stan code (not the names
used in \R). For more details on specifying initial values you can consult 
the documentation of the selected \code{backend}.}

\item{chains}{Number of Markov chains (defaults to 4).}

\item{iter}{Number of total iterations per chain (including warmup; defaults
to 2000).}

\item{warmup}{A positive integer specifying number of warmup (aka burnin)
iterations. This also specifies the number of iterations used for stepsize
adaptation, so warmup draws should not be used for inference. The number
of warmup should not be larger than \code{iter} and the default is
\code{iter/2}.}

\item{thin}{Thinning rate. Must be a positive integer. Set \code{thin > 1} to
save memory and computation time if \code{iter} is large.}

\item{cores}{Number of cores to use when executing the chains in parallel,
which defaults to 1 but we recommend setting the \code{mc.cores} option to
be as many processors as the hardware and RAM allow (up to the number of
chains). For non-Windows OS in non-interactive \R sessions, forking is used
instead of PSOCK clusters.}

\item{threads}{Number of threads to use in within-chain parallelization. For
more control over the threading process, \code{threads} may also be a
\code{brmsthreads} object created by \code{\link[brms]{threading}}. Within-chain
parallelization is experimental! We recommend its use only if you are
experienced with Stan's \code{reduce_sum} function and have a slow running
model that cannot be sped up by any other means.}

\item{algorithm}{Character string naming the estimation approach to use.
Options are \code{"sampling"} for MCMC (the default), \code{"meanfield"} for
variational inference with independent normal distributions,
\code{"fullrank"} for variational inference with a multivariate normal
distribution, or \code{"fixed_param"} for sampling from fixed parameter
values. Can be set globally for the current \R session via the
\code{"brms.algorithm"} option (see \code{\link{options}}).}

\item{backend}{Character string naming the package to use as the backend for
fitting the Stan model. Options are \code{"rstan"} (the default) or
\code{"cmdstanr"}. Can be set globally for the current \R session via the
\code{"brms.backend"} option (see \code{\link{options}}). Details on the
\pkg{rstan} and \pkg{cmdstanr} packages are available at
\url{https://mc-stan.org/rstan/} and \url{https://mc-stan.org/cmdstanr/},
respectively. Additionally a \code{"mock"} backend is available to make
testing \pkg{brms} and packages that depend on it easier. 
The \code{"mock"} backend does not actually do any fitting, it only checks
the generated Stan code for correctness and then returns whatever is passed
in an additional \code{mock_fit} argument as the result of the fit.}

\item{stan_args}{A list of extra arguments to \pkg{Stan}.}

\item{control}{A named \code{list} of parameters to control the sampler's
behavior. It defaults to \code{NULL} so all the default values are used.
The most important control parameters are discussed in the 'Details'
section below. For a comprehensive overview see
\code{\link[rstan:stan]{stan}}.}

\item{save_pars}{An object generated by \code{\link[brms]{save_pars}} controlling
which parameters should be saved in the model. The argument has no
impact on the model fitting itself.}

\item{save_model}{Either \code{NULL} or a character string. In the latter
case, the model's Stan code is saved via \code{\link{cat}} in a text file
named after the string supplied in \code{save_model}.}

\item{file}{A character string of the file path to \code{brmsfit} object
saved via \code{\link{saveRDS}}.}

\item{file_refit}{Modifies when the fit stored via the \code{file} parameter
is re-used. Can be set globally for the current \R session via the
\code{"brms.file_refit"} option (see \code{\link{options}}). 
For \code{"never"} (default) the fit is always loaded if it
exists and fitting is skipped. For \code{"always"} the model is always
refitted. If set to \code{"on_change"}, brms will
refit the model if model, data or algorithm as passed to Stan differ from
what is stored in the file. This also covers changes in priors,
\code{sample_prior}, \code{stanvars}, covariance structure, etc. If you
believe there was a false positive, you can use
\code{\link[brms]{brmsfit_needs_refit}} to see why refit is deemed necessary.
Refit will not be triggered for changes in additional parameters of the fit
(e.g., initial values, number of iterations, control arguments, ...). A
known limitation is that a refit will be triggered if within-chain
parallelization is switched on/off.}

\item{normalize}{Logical. Indicates whether normalization constants should
be included in the Stan code (defaults to \code{TRUE}). Setting it
to \code{FALSE} requires Stan version >= 2.25 to work. If \code{FALSE},
sampling efficiency may be increased but some post processing functions
such as \code{\link[brms]{bridge_sampler}} will not be available. Can be 
controlled globally for the current \R session via the `brms.normalize`
option.}

\item{future}{Logical; If \code{TRUE}, the \pkg{\link[future:future]{future}}
package is used for parallel execution of the chains and argument
\code{cores} will be ignored. Can be set globally for the current \R
session via the \code{"future"} option. The execution type is controlled via
\code{\link[future:plan]{plan}} (see the examples section below).}

\item{seed}{The seed for random number generation to make results
reproducible. If \code{NA} (the default), \pkg{Stan} will set the seed
randomly.}

\item{silent}{Verbosity level between \code{0} and \code{2}.
If \code{1} (the default), most of the
informational messages of compiler and sampler are suppressed.
If \code{2}, even more messages are suppressed. The actual
sampling progress is still printed. Set \code{refresh = 0} to turn this off
as well. If using \code{backend = "rstan"} you can also set
\code{open_progress = FALSE} to prevent opening additional progress bars.}

\item{object}{A Bayesian model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Other arguments passed to internal functions.}

\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link[brms]{brmsformula}}, or \code{\link[brms]{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link[brms]{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}
}
\value{
An updated model specification.
}
\description{
\code{bayesian()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
\pkg{Stan} via \pkg{brms} package in \pkg{R}.
}
\details{
The arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be
used in lieu of recreating the object from scratch.

The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{bayesian()}, the
possible modes are "regression" and "classification".

The model can be created by the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{brms}:  \code{"brms"}
}
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are:\if{html}{\out{<div class="sourceCode r">}}\preformatted{bayesian() \%>\%
  set_engine("brms") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## Bayesian Model Specification (regression)
## 
## Computational engine: brms 
## 
## Model fit template:
## bayesian::bayesian_fit(formula = missing_arg(), data = missing_arg())
}
}

\examples{

bayesian()

show_model_info("bayesian")

bayesian(mode = "classification")
bayesian(mode = "regression")
\dontrun{
bayesian_mod <-
  bayesian() \%>\%
  set_engine("brms") \%>\%
  fit(
    rating ~ treat + period + carry + (1 | subject),
    data = inhaler
  )

summary(bayesian_mod$fit)
}


model <- bayesian(inits = "random")
model
update(model, inits = "0")
update(model, inits = "0", fresh = TRUE)
}
\seealso{
\code{\link[brms]{brm}},
\code{\link[brms]{brmsfit}},
\code{\link[brms]{update.brmsfit}},
\code{\link[brms]{predict.brmsfit}},
\code{\link[brms]{posterior_epred.brmsfit}},
\code{\link[brms]{posterior_predict.brmsfit}},
\code{\link[brms]{brmsformula}},
\code{\link[brms]{brmsformula-helpers}},
\code{\link[brms]{brmsterms}},
\code{\link[brms]{brmsfamily}},
\code{\link[brms]{customfamily}},
\code{\link[stats]{family}},
\code{\link[stats]{formula}},
\code{\link[stats]{update.formula}}.
}
