% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopodRaster.R
\name{lopodRaster}
\alias{lopodRaster}
\title{Crate raster object for a parameter estimated in a LopodModel}
\usage{
lopodRaster(LopodModel, param, extrapolate = T, metric = NULL,
  quant = 0.5)
}
\arguments{
\item{LopodModel}{A LopodModel object}

\item{param}{Unit-level model parameter to be mapped. Values "psi_Sampled" can be mapped for models without CAR analyses, "psi_i" for LopodModels with CAR analysis and "pp","cellpres_i", "pCorr","sim_y","sim_true_y","sim_false_y" for both.}

\item{extrapolate}{Boolean. If True, parameters are mapped for cells that have not been sampled, this can only be done in LopodModels with CAR analysis. Only plotted for "psi_i", "pp" and, "cellpres_i".}

\item{metric}{"mean" or "sd". Plots the mean or standard deviation of the posterior distribution. If NULL, the value in quant is used.}

\item{quant}{Returns the raster for a given quantile of the posterior distribution. Default is 0.5 (the median of the posterior distribution). Not used if metric is other than NULL}
}
\value{
A Raster object.
}
\description{
Crate raster object for a parameter estimated in a LopodModel
}
\examples{
\dontrun{
data("simSpRecords", package = "bayesLopod")
data("simSpSamplingEffort", package = "bayesLopod")
simSpRasters = xyToRaster(xyRecords = simSpRecords,xySamplingEffort = simSpSamplingEffort,
basemap = NULL, nrows = 50, extentExpansion = 0)
ld_Raster_adMatrix = rasterLopodData(rasterN = simSpRasters[["samplingEffort"]],
rasterY = simSpRasters[["spDetections"]], Adjacency = TRUE )
mLopodRaster = modelLopod(LopodData = ld_Raster_adMatrix, varP = TRUE, q = NULL,
pmin = 0.1, CAR = FALSE, nChains = 4,warmup = 500,sampling = 100,nCores = 4)

psiRaster = lopodRaster(mLopodRaster, param = "psi_i", extrapolate = TRUE, quant = 0.5)
ppRaster = lopodRaster(mLopodRaster, param = "pp", extrapolate = FALSE, metric = "mean")

Visualize results
sp::spplot(psiRaster)
sp::spplot(ppRaster)
}
}
