% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{study_details}
\alias{study_details}
\title{Details of the clinical study}
\usage{
study_details(
  total_sample_size,
  study_period,
  interim_look = NULL,
  prop_loss_to_followup = 0.1,
  .data = NULL
)
}
\arguments{
\item{total_sample_size}{integer. The number of sample size needed.}

\item{study_period}{integer. The length of the study.}

\item{interim_look}{vector. Vector with interim looks.}

\item{prop_loss_to_followup}{integer. The proportion of loss to follow up.}

\item{.data}{NULL. This should not be changed by the user.}
}
\value{
a list with sample size, length of the study, interim looks and proportion loss to follow up
}
\description{
Wrapper function for details of the clinical trial simulation.
}
\examples{
study_details(total_sample_size = 300, study_period = 50, interim_look = c(210, 240, 270))
}
