% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{data_survival}
\alias{data_survival}
\title{Data file for survival analysis}
\usage{
data_survival(time, treatment, event, .data = NULL)
}
\arguments{
\item{time}{vector. exposure time for the subjects. It must be the same length
as the treatment variable.}

\item{treatment}{vector. treatment assignment for patients, 1 for treatment group and
0 for control group}

\item{event}{vector. The status indicator, normally 0=alive, 1=dead.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death).
For censored data, the status indicator is 0=right censored, 1 = event at time.
Although unusual, the event indicator can be omitted, in which case
all subjects are assumed to have an event.}

\item{.data}{NULL. stores the survival data for analysis, please do not fill it in.}
}
\value{
a list with time, treatment, and event with time-to-event
  outcome.
}
\description{
Wrapper function for data file in survival analysis.
}
\examples{
data_survival(time       = c(6.2, 8.2, 8.0, 2.3),
                        treatment  = c(0, 1, 0, 1),
                        event      = c(1, 1, 1, 1))

}
