% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine}
\alias{combine}
\title{Combine two \code{bayesAB} objects given a binary function.}
\usage{
combine(bT1, bT2, f = `+`, params, newName)
}
\arguments{
\item{bT1}{a bayesTest object}

\item{bT2}{a bayesTest object}

\item{f}{a binary function (f(x, y)) used to combine posteriors from bT1 to bT2}

\item{params}{a character vector of length 2, corresponding to names of the posterior parameters you want to combine;
defaults to first posterior parameter if not supplied}

\item{newName}{a string indicating the name of the new 'posterior' in the resulting object;
defaults to string representation of f(params[1], params[2])}
}
\value{
a \code{bayesTest} object with the newly combined posterior samples.
}
\description{
Combine two (or any number, in succession) \code{bayesTest} objects into a new arbitrary posterior distribution.
             The resulting object is of the same class.
}
\note{
The generics `+.bayesTest`, `*.bayesTest`, `-.bayesTest`, and `/.bayesTest` are shorthand for
      combine(f = `+`), combine(f = `*`), combine(f = `-`), and combine(f = `/`).
}
\examples{
A_binom <- rbinom(100, 1, .5)
B_binom <- rbinom(100, 1, .6)

A_norm <- rnorm(100, 6, 1.5)
B_norm <- rnorm(100, 5, 2.5)

AB1 <- bayesTest(A_binom, B_binom,
                 priors = c('alpha' = 1, 'beta' = 1),
                 distribution = 'bernoulli')

AB2 <- bayesTest(A_norm, B_norm,
                priors = c('mu' = 5, 'sd' = 1, 'shape' = 3, 'scale' = 1),
                distribution = 'normal')

AB3 <- combine(AB1, AB2, f = `*`, params = c('Probability', 'Mu'), newName = 'Expectation')
# Equivalent to
AB3 <- AB1 * grab(AB2, 'Mu')

# To get the same posterior name as well
AB3 <- rename(AB3, 'Expectation')

# Dummy example
weirdVariable <- (AB1 + AB2) * (AB2 / AB1)
weirdVariable <- rename(weirdVariable, 'confusingParam')

print(AB3)
summary(AB3)
plot(AB3)
}
\seealso{
\code{\link{grab}}
}
