% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_success_rate.R
\name{b_success_rate}
\alias{b_success_rate}
\title{b_success_rate}
\usage{
b_success_rate(r, s, priors = NULL, warmup = 1000, iter = 2000,
  chains = 4, seed = NULL, refresh = NULL, control = NULL,
  suppress_warnings = TRUE)
}
\arguments{
\item{r}{a vector containing test results (0 - test was not solved successfully, 1 - test was solved successfully).}

\item{s}{a vector containing subject indexes. Starting index should be 1 and the largest subject index should equal the number of subjects.}

\item{priors}{List of parameters and their priors - b_prior objects. You can put a prior on the p (mean probability of success) and tau (variance) parameters (default = NULL).}

\item{warmup}{Integer specifying the number of warmup iterations per chain (default = 1000).}

\item{iter}{Integer specifying the number of iterations (including warmup, default = 2000).}

\item{chains}{Integer specifying the number of parallel chains (default = 4).}

\item{seed}{Random number generator seed (default = NULL).}

\item{refresh}{Frequency of output (default = NULL).}

\item{control}{A named list of parameters to control the sampler's behavior (default = NULL).}

\item{suppress_warnings}{Suppress warnings returned by Stan (default = TRUE).}
}
\value{
An object of class `success_rate_class`.
}
\description{
Bayesian model for comparing test success rate.
}
\examples{
\donttest{
# priors
p_prior <- b_prior(family="beta", pars=c(1, 1))
tau_prior <- b_prior(family="uniform", pars=c(0, 500))

# attach priors to relevant parameters
priors <- list(c("p", p_prior),
               c("tau", tau_prior))

# generate data
s <- rep(1:5, 20)
data <- rbinom(100, size=1, prob=0.6)

# fit
fit <- b_success_rate(r=data, s=s, priors=priors, chains=1)
}

}
