% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JobNames.R
\name{JobNames}
\alias{JobNames}
\alias{setJobNames}
\alias{getJobNames}
\title{Set and Retrieve Job Names}
\usage{
setJobNames(ids = NULL, names, reg = getDefaultRegistry())

getJobNames(ids = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.
Invalid ids are ignored.}

\item{names}{[\code{character}]\cr
Character vector of the same length as provided ids.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
\code{setJobNames} returns \code{NULL} invisibly, \code{getJobTable}
 returns a \code{data.table} with columns \code{job.id} and \code{job.name}.
}
\description{
Set custom names for jobs. These are passed to the template as \sQuote{job.name}.
If no custom name is set (or any of the job names of the chunk is missing),
the job hash is used as job name.
Individual job names can be accessed via \code{jobs$job.name}.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
ids = batchMap(identity, 1:10, reg = tmp)
setJobNames(ids, letters[1:nrow(ids)], reg = tmp)
getJobNames(reg = tmp)
}
