% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsMulticore.R
\name{makeClusterFunctionsMulticore}
\alias{makeClusterFunctionsMulticore}
\title{ClusterFunctions for Parallel Multicore Execution}
\usage{
makeClusterFunctionsMulticore(ncpus = NA_integer_)
}
\arguments{
\item{ncpus}{[\code{integer(1)}]\cr
Number of VPUs of worker.
Default is to use all cores. The total number of cores "available" can be set via the option \code{mc.cores}
and defaults to the heuristic implemented in \code{\link[parallel]{detectCores}}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
Jobs are spawned asynchronously using the functions \code{mcparallel} and \code{mccollect} (both in \pkg{parallel}).
Does not work on Windows, use \code{\link{makeClusterFunctionsSocket}} instead.
}
\note{
Sets the number of threads internally used by \pkg{data.table} to 1 during initialization (via \code{data.table::setthreads}).
}
\seealso{
Other ClusterFunctions: \code{\link{makeClusterFunctionsDocker}},
  \code{\link{makeClusterFunctionsInteractive}},
  \code{\link{makeClusterFunctionsLSF}},
  \code{\link{makeClusterFunctionsOpenLava}},
  \code{\link{makeClusterFunctionsSGE}},
  \code{\link{makeClusterFunctionsSSH}},
  \code{\link{makeClusterFunctionsSlurm}},
  \code{\link{makeClusterFunctionsSocket}},
  \code{\link{makeClusterFunctionsTorque}},
  \code{\link{makeClusterFunctions}}
}

