% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{batch_files_remaining}
\alias{batch_files_remaining}
\title{Batch Files}
\usage{
batch_files_remaining(path, failed = FALSE)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{failed}{A logical scalar specifying how to treat files
that previously failed to process. If FALSE (the default) failed files
are excluded, if NA they are included and if TRUE they are only included.}
}
\value{
A character vector of the names of the remaining files.
}
\description{
Gets the names of the files that are remaining to be processed by
\code{\link[=batch_run]{batch_run()}}.
}
\details{
\code{\link[=batch_completed]{batch_completed()}} can be used to test if there are any
files remaining.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_files_remaining(path)
batch_run(path, ask = FALSE)
batch_files_remaining(path)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}} and \code{\link[=batch_run]{batch_run()}}
}
