% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_pam.R
\name{permute_pam}
\alias{permute_pam}
\title{permute_pam: Function to permute a Presence-Absence-Matrix.}
\usage{
permute_pam(m, niter = NULL, as_sparse = FALSE)
}
\arguments{
\item{m}{Presence-Absence-Matrix (PAM) or a binary matrix with columns
representing species and rows sites.}

\item{niter}{Number of iterations to permute the PAM.}

\item{as_sparse}{If TRUE the PAM will be returned as a sparse matrix}
}
\value{
Returns a permuted matrix of the same dimensions of m
(same number of rows and columns). Note that the sum of each row and column
of this permuted matrix is equal to that of m.
species.
}
\description{
permute_pam: Function to permute a Presence-Absence-Matrix.
}
\details{
This function is an implementation of the curve ball algorithm
          following Strona et al. (2014).
}
\examples{
set.seed(111)
pam <- matrix(rbinom(100,1,0.3),nrow = 10,ncol = 10)
ppam <- bamm::permute_pam(m = pam,niter = NULL,as_sparse = FALSE)
# Check if matrices are different
all(pam == ppam)
# Check if row totals are the same
all(Matrix::rowSums(pam) == Matrix::rowSums(ppam))
# Check if column total are the same
all(Matrix::colSums(pam) == Matrix::colSums(ppam))
}
\references{
\insertRef{Strona2014}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
