% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbp.R
\name{sbp.fromPBA}
\alias{sbp.fromPBA}
\title{Build SBP Matrix of Principal Balances}
\usage{
sbp.fromPBA(x, alpha = NA)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{alpha}{A double. Defines a hyper-parameter used
by the Box-Cox transformation to approximate log-ratio
variance in the presence of zeros. Skip with NA.}
}
\value{
An SBP matrix.
}
\description{
This function builds an SBP of principal balances using the
 hierarchical clustering of components method described
 by Pawlowsky-Glahn et al. in "Principal balances"
 from the CoDaWork 2011 proceedings.
}
\examples{
library(balance)
data(iris)
x <- iris[,1:4]
sbp.fromPBA(x)

}
\author{
Thom Quinn
}
