% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.mcmclist.R
\name{final.values.mcmc}
\alias{final.values.mcmc}
\title{Values of the last iteration for each chain}
\usage{
final.values.mcmc(mcmclist, ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{...}{Further arguments.}
}
\value{
A list with the last values simulated from a \emph{mcmc.2pnob} or
\emph{mcmc.3pnob} class object.
}
\description{
This function gives the values of the last iteration for each chain. This is
useful for assign the initial values from new MCMC models.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 100, burning = 0)

# continue the  MCMC for the Two-Parameter Normal Ogive Model
initialValues2 <- final.values.mcmc(model2)
model121 <- mcmc.2pnob(MathTest[1:500,], initial.value = initialValues2,
iter = 100, burning = 0)

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
model3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500)

# continue the  MCMC for the Three-Parameter Normal Ogive Model
initialValues3 <- final.values.mcmc(model3)
model131 <- mcmc.3pnob(MathTest, initial.value = initialValues3,
iter = 3000, burning = 0)
}

## End(Not run)

}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
