% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPDF.R
\name{create_PDF}
\alias{create_PDF}
\title{Make barcodes and print labels}
\usage{
create_PDF(user = FALSE, Labels = NULL, name = "LabelsOut",
  type = "matrix", ErrCorr = "H", Fsz = 2.5, ...)
}
\arguments{
\item{user}{logical. Run function using interactive mode (prompts user for
parameter values) Default is \code{FALSE}}

\item{Labels}{vector or data frame object containing label names (i.e. unique
ID codes) with either UTF-8 or ASCII encoding.}

\item{name}{character. Name of the PDF output file. Default is
\code{"LabelsOut"}.}

\item{type}{character. Choice of \code{"linear"} code 128 or \code{"matrix"}
QR code labels. Default is \code{"matrix"}.}

\item{ErrCorr}{error correction value for matrix labels only. Level of damage
from low to high: \code{"L"}, \code{"M"}, \code{"Q"}, \code{"H"}. Default
is \code{"H"}.}

\item{Fsz}{numerical. Sets font size in points. Longer ID codes may be shrunk
to fit if truncation is not used for matrix labels. Default font size is
\code{5}. ID codes are also shrunk automatically to fit on the label if
actual size is bigger than label dimensions.}

\item{...}{advanced arguments to modify the PDF layout. See
\code{\link{custom_create_PDF}} for arguments. The advanced options can be
 accessed interactively with \code{user = TRUE} and then entering TRUE when prompted to
  modify advanced options.}
}
\value{
a PDF file containing QR-coded labels, saved to the default directory.
}
\description{
Input vector or data.frame of ID codes to produce a PDF of QR codes which can
be printed. This is a wrapper function for \code{\link{custom_create_PDF}}.
See details of \code{\link{custom_create_PDF}} on how to format text labels
if needed.
}
\details{
#' The default PDF setup is for ULINE 1.75" * 0.5" WEATHER RESISTANT LABEL for laser
printer; item # S-19297 (uline.ca). The page format can be modified using
the \code{...} (advanced arguments) for other label types.
}
\examples{
## data frame
example_vector <- as.data.frame(c("ao1", "a02", "a03"))

\dontrun{
## run with default options
## pdf file will be "example.pdf" saved into a temp directory

create_PDF(Labels = example_vector, name = file.path(tempdir(), "example"))

## view example output from temp folder
system(paste0('open "', file.path(tempdir(), "example"), ".pdf"))
}

## run interactively. Overrides default pdf options
if(interactive()){
    create_PDF(user = TRUE, Labels = example_vector)
}

\donttest{
## run using a data frame, automatically choosing the "label" column
example_df <- data.frame("level1" = c("a1", "a2"), "label" = c("a1-b1",
"a1-b2"), "level2" = c("b1", "b1"))
create_PDF(user = FALSE, Labels = example_df, name = file.path(tempdir(), "example_2"))
}

\donttest{
## run using an unnamed data frame
example_df <- data.frame(c("a1", "a2"), c("a1-b1", "a1-b2"), c("b1", "b1"))
## specify column from data frame
create_PDF(user = FALSE, Labels = example_df[,2], name = file.path(tempdir(), "example_3"))
}
\donttest{
## create linear (code128) label rather than matrix (2D/QR) labels
example_df <- data.frame(c("a1", "a2"), c("a1-b1", "a1-b2"), c("b1", "b1"))
## specify column from data frame
create_PDF(user = FALSE, Labels = example_df, name = file.path(tempdir(),
"example_4", type = "linear"))
}
}
\seealso{
\code{\link{custom_create_PDF}}
}
