% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_level.R
\name{.add_meta_variables}
\alias{.add_meta_variables}
\title{Add additional meta variable}
\usage{
.add_meta_variables(
  additional_fields = NULL,
  log_level = NULL,
  namespace = NA_character_,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{additional_fields}{A named vector of type list with key-value pairs of
additional meta data which needs to be added in logging context on top of
\code{log_fields}. The respective value of each key is expected to be of
length 1. It is \code{NULL} by default.}

\item{log_level}{log level as per \code{\link[logger]{log_levels}}}

\item{namespace}{string referring to the \code{logger} environment / config to be used to override the target of the message record to be used instead of the default namespace, which is defined by the R package name from which the logger was called, and falls back to a common, global namespace.}

\item{.logcall}{the logging call being evaluated (useful in formatters and layouts when you want to have access to the raw, unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was called (useful in formatters and layouts to extract the calling function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function where the formatter function will be evaluated and that is used to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
Returns a vector of collected meta-data. It is used in defining the
\code{\link[logger]{log_layout}} function.
}
\description{
Add additional meta variables in the logging context on top of the ones
that are readily collected in \code{\link[logger]{get_logger_meta_variables}}
function. It might be needed to add some other metadata specific to the
logging usage - that goal is served by this function.
}
