% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendemail.R, R/statistics.R
\name{send_email}
\alias{get_quota}
\alias{get_statistics}
\alias{send_email}
\title{Send Email via SES}
\usage{
send_email(message, html, raw = NULL, subject, from, to = NULL, cc = NULL,
  bcc = NULL, replyto = NULL, returnpath = NULL, charset.subject = NULL,
  charset.message = NULL, charset.html = NULL, ...)

get_quota(...)

get_statistics(...)
}
\arguments{
\item{message}{A character string specifying the message body (as plain text). Must specify \code{html}, \code{message}, or both; or alternatively \code{raw}.}

\item{html}{A character string specifying the message body (as HTML). Must specify \code{html}, \code{message}, or both; or alternatively \code{raw}.}

\item{raw}{A raw vector containing a valid email body (of no more than 10MB in size). Can only specify \code{raw} xor \code{message}/\code{html}.}

\item{subject}{A character string specifying the email subject}

\item{from}{A character string specifying teh sender}

\item{to}{A character vector of TO recipient email addresses.}

\item{cc}{A character vector of CC recipient email addresses.}

\item{bcc}{A character vector of BCC recipient email addresses.}

\item{replyto}{A character vector of reply-to email addresses.}

\item{returnpath}{A character string specifying the email address to which feedback and bounces are sent.}

\item{charset.subject}{An optional character string specifying the character set, e.g., \dQuote{UTF-8}, \dQuote{ISO-8859-1}, etc. if \code{subject} is not ASCII.}

\item{charset.message}{An optional character string specifying the character set, e.g., \dQuote{UTF-8}, \dQuote{ISO-8859-1}, etc. if \code{message} is not ASCII.}

\item{charset.html}{An optional character string specifying the character set, e.g., \dQuote{UTF-8}, \dQuote{ISO-8859-1}, etc. if \code{html} is not ASCII.}

\item{\dots}{Additional arguments passed to \code{\link{sesPOST}}.}
}
\value{
A character string containg the message ID.
}
\description{
Send email via Amazon SES service
}
\details{
Send a test or raw email message. \code{get_quota} and \code{get_statistics} provide information on remaining and used email rate limits, respectively.
}
\examples{
\dontrun{
# verify email address
verify_identity("me@example.com")

# if email verified, can be used to send a message
a <- get_verification_attrs("me@example.com")
if (a[[1]]$VerificationStatus == "Success") {
  # simple plain-text email
  send_email("Test Email Body", subject = "Test Email", 
             from = "me@example.com", to = "recipient@example.com")

  # html and plain text versions
  send_email(message = "Plain text body", 
             html = "<div><p style='font-weight=bold;'>HTML text body</p></div>", 
             subject = "Test Email", 
             from = "me@example.com", to = "recipient@example.com")
}
}
\dontrun{
get_quota()
get_statistics()
} 
}

