% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_list_tags_for_resource}
\alias{ecs_list_tags_for_resource}
\title{List Tags For Resource}
\usage{
ecs_list_tags_for_resource(
  resourceArn = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{resourceArn}{Character. The Amazon Resource Name (ARN) that identifies the resource for which to list the tags.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
List the tags for an Amazon ECS
resource.
}
\section{resourceArn}{

The Amazon Resource Name (ARN) that identifies
the resource for which to list the tags. Currently, the supported
resources are Amazon ECS tasks, services, task definitions, clusters,
and container instances.
}

