% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_update_security_group_rule_descriptions_egress}
\alias{ec2_update_security_group_rule_descriptions_egress}
\title{Update Security Group Rule Descriptions Egress}
\usage{
ec2_update_security_group_rule_descriptions_egress(
  IpPermissions,
  DryRun = NULL,
  GroupId = NULL,
  GroupName = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{IpPermissions}{List. The IP permissions for the security group rule.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{GroupId}{Character. The ID of the security group.[optional]}

\item{GroupName}{Character. [Default VPC] The name of the security group.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Update Security Group Rule Descriptions Egress
}
\section{IpPermissions}{

The IP permissions for the
security group rule.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{GroupId}{

The ID of the security
group. You must specify either the security group ID or the security
group name in the request. For security groups in a nondefault VPC, you
must specify the security group ID.
}

\section{GroupName}{

[Default VPC]
The name of the security group. You must specify either the security
group ID or the security group name in the
request.
}

