% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_spot_instance_requests}
\alias{ec2_describe_spot_instance_requests}
\title{Describe Spot Instance Requests}
\usage{
ec2_describe_spot_instance_requests(
  Filter = NULL,
  DryRun = NULL,
  SpotInstanceRequestId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{SpotInstanceRequestId}{List. One or more Spot Instance request IDs.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Spot Instance Requests
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{availability-zone-group} - The Availability Zone group.
\item \code{create-time} - The time stamp when the Spot Instance request was
created.
\item \code{fault-code} - The fault code related to the request.
\item \code{fault-message} - The fault message related to the request.
\item \code{instance-id} - The ID of the instance that fulfilled the request.
\item \code{launch-group} - The Spot Instance launch group.
\item \code{launch.block-device-mapping.delete-on-termination} - Indicates
whether the EBS volume is deleted on instance termination.
\item \code{launch.block-device-mapping.device-name} - The device name for the
volume in the block device mapping (for example, \verb{/dev/sdh} or
\code{xvdh}).
\item \code{launch.block-device-mapping.snapshot-id} - The ID of the snapshot
for the EBS volume.
\item \code{launch.block-device-mapping.volume-size} - The size of the EBS
volume, in GiB.
\item \code{launch.block-device-mapping.volume-type} - The type of EBS volume:
\code{gp2} for General Purpose SSD, \code{io1} or \code{io2} for Provisioned IOPS
SSD, \code{st1} for Throughput Optimized HDD, \code{sc1}for Cold HDD, or
\code{standard} for Magnetic.
\item \code{launch.group-id} - The ID of the security group for the instance.
\item \code{launch.group-name} - The name of the security group for the
instance.
\item \code{launch.image-id} - The ID of the AMI.
\item \code{launch.instance-type} - The type of instance (for example,
\code{m3.medium}).
\item \code{launch.kernel-id} - The kernel ID.
\item \code{launch.key-name} - The name of the key pair the instance launched
with.
\item \code{launch.monitoring-enabled} - Whether detailed monitoring is enabled
for the Spot Instance.
\item \code{launch.ramdisk-id} - The RAM disk ID.
\item \code{launched-availability-zone} - The Availability Zone in which the
request is launched.
\item \code{network-interface.addresses.primary} - Indicates whether the IP
address is the primary private IP address.
\item \code{network-interface.delete-on-termination} - Indicates whether the
network interface is deleted when the instance is terminated.
\item \code{network-interface.description} - A description of the network
interface.
\item \code{network-interface.device-index} - The index of the device for the
network interface attachment on the instance.
\item \code{network-interface.group-id} - The ID of the security group
associated with the network interface.
\item \code{network-interface.network-interface-id} - The ID of the network
interface.
\item \code{network-interface.private-ip-address} - The primary private IP
address of the network interface.
\item \code{network-interface.subnet-id} - The ID of the subnet for the
instance.
\item \code{product-description} - The product description associated with the
instance (\code{Linux/UNIX} \| \code{Windows}).
\item \code{spot-instance-request-id} - The Spot Instance request ID.
\item \code{spot-price} - The maximum hourly price for any Spot Instance
launched to fulfill the request.
\item \code{state} - The state of the Spot Instance request (\code{open} \| \code{active}
\| \code{closed} \| \code{cancelled} \| \code{failed}). Spot request status
information can help you track your Amazon EC2 Spot Instance
requests. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html}{Spot request status}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
\item \code{status-code} - The short code describing the most recent evaluation
of your Spot Instance request.
\item \code{status-message} - The message explaining the status of the Spot
Instance request.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{type} - The type of Spot Instance request (\code{one-time} \|
\code{persistent}).
\item \code{valid-from} - The start date of the request.
\item \code{valid-until} - The end date of the request.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{SpotInstanceRequestId}{

One or more Spot Instance
request IDs.
}

\section{MaxResults}{

The maximum number of results to return in a
single call. Specify a value between 5 and 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.
}

